<?php
// CONTEXTO MEJORADO CON RESUMEN INTELIGENTE
$archivo_contexto = 'contexto_gaston.json';

// 1. CREAR O CARGAR CONTEXTO
if (!file_exists($archivo_contexto)) {
    $contexto = [
        'conversaciones' => [],
        'resumen_actual' => 'Conversación nueva. El usuario aún no ha compartido información personal.'
    ];
    file_put_contents($archivo_contexto, json_encode($contexto, JSON_PRETTY_PRINT));
} else {
    $contexto = json_decode(file_get_contents($archivo_contexto), true);
}

// 2. FUNCIÓN PARA RESUMIR CONVERSACIÓN
function generarResumenInteligente($conversaciones) {
    if (count($conversaciones) === 0) {
        return "Conversación nueva. Sin historial previo.";
    }
    
    // Tomar solo las últimas 8 interacciones (balance entre contexto y performance)
    $ultimas = array_slice($conversaciones, -8);
    
    $resumen = "Resumen de conversación reciente (últimos " . count($ultimas) . " mensajes):\n";
    foreach ($ultimas as $index => $conv) {
        $numero = $index + 1;
        $resumen .= "{$numero}. [{$conv['fecha']}] {$conv['mensaje']}\n";
    }
    
    // Detectar información personal del usuario
    $info_personal = "";
    foreach ($conversaciones as $conv) {
        $mensaje = strtolower($conv['mensaje']);
        if (strpos($mensaje, 'me llamo') !== false || strpos($mensaje, 'mi nombre es') !== false) {
            $info_personal .= "El usuario ha compartido su nombre. ";
        }
        if (strpos($mensaje, 'gastón') !== false) {
            $info_personal .= "El usuario se llama Gastón. ";
        }
    }
    
    if ($info_personal) {
        $resumen = $info_personal . "\n" . $resumen;
    }
    
    return $resumen;
}

// 3. GUARDAR EL MENSAJE ACTUAL
$mensaje = $_POST['mensaje'] ?? '';

if ($mensaje) {
    // AGREGAR A LA CONVERSACIÓN (máximo 25 mensajes)
    $contexto['conversaciones'][] = [
        'fecha' => date('Y-m-d H:i:s'),
        'mensaje' => $mensaje
    ];
    
    // MANTENER SOLO ÚLTIMOS 25 MENSAJES
    if (count($contexto['conversaciones']) > 25) {
        $contexto['conversaciones'] = array_slice($contexto['conversaciones'], -25);
    }
    
    // ACTUALIZAR RESUMEN
    $contexto['resumen_actual'] = generarResumenInteligente($contexto['conversaciones']);
    
    // GUARDAR
    file_put_contents($archivo_contexto, json_encode($contexto, JSON_PRETTY_PRINT));
}

// 4. DEVOLVER EL CONTEXTO COMPLETO
header('Content-Type: application/json');
echo json_encode($contexto, JSON_PRETTY_PRINT);
?>