const CACHE_NAME = 'ia-webhook-pro-v1';
const urlsToCache = [
  '/ia-webhook/panel_master.php',
  '/ia-webhook/config.php'
  // contexto_gaston.json NO va al cache - se lee siempre fresco
];

self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(cache => cache.addAll(urlsToCache))
  );
});

self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(cacheNames => {
      return Promise.all(
        cacheNames.map(cacheName => {
          if (cacheName !== CACHE_NAME) {
            return caches.delete(cacheName);
          }
        })
      );
    })
  );
});

self.addEventListener('fetch', event => {
  // contexto_ia.php → SIEMPRE online
  if (event.request.url.includes('contexto_ia.php')) {
    event.respondWith(fetch(event.request));
    return;
  }
  
  // contexto_gaston.json → SIEMPRE versión fresca (NO CACHE)
  if (event.request.url.includes('contexto_gaston.json')) {
    event.respondWith(fetch(event.request));
    return;
  }
  
  // El resto: cache + internet
  event.respondWith(
    caches.match(event.request)
      .then(response => response || fetch(event.request))
  );
});